// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : global.h
// Date           : February 2008
//
// Description    : This file contains the constants (as #define directives)
//                  that are globally used across the application.
//
//                  The 'log.h' header is used by all classes and therefore
//                  included in here to ensure it is always available for use.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once

#include <string>

#include "log.h"



// Debug Enable
#define USE_DEBUG             0

// Version ID to appear on the bottom-right corner of the Main Menu
#define VERSION_ID            "V1.03GR"

#define PI                    3.14159265f



namespace Dobbs
{
  enum DirFlags
  {
    DIR_NONE              = 0,
    DIR_LEFT              = 0x01,
    DIR_RIGHT             = 0x02,
    DIR_UP                = 0x04,
    DIR_DOWN              = 0x08,
    DIR_FALL              = 0x10,
    DIR_FORCED_MOVE       = 0x20,   // force move without collision
    DIR_DIRECTED_MOVE     = 0x40,   // moved by vehicle, change left/right direction
    DIR_PLATFORM_MOVE     = 0x80,   // moved by platform
  };

  enum Constants
  {
    SCREEN_WIDTH          = 800,
    SCREEN_HEIGHT         = 600,
    TILE_WIDTH            = 32,
    TILE_HEIGHT           = 32,

    LEVEL_DEFAULT_WIDTH   = 25,
    LEVEL_DEFAULT_HEIGHT  = 19,
  };

  enum TileType
  {
    TILE_EMPTY = 0,
    TILE_GRASS,
    TILE_GLUE,
    TILE_ICE,
    TILE_STEEL,
    TILE_V_STEEL,
    TILE_DOOR_RED,
    TILE_DOOR_YELLOW,
    TILE_DOOR_GREEN,
    TILE_DOOR_BLUE,
    TILE_SPIKE,
    TILE_BRIDGE,
    TILE_FLASH,
    TILE_GRASS_N,
    TILE_GRASS_S,
    TILE_GRASS_NW,
    TILE_GRASS_NE,
    TILE_GRASS_CENTER,
    TILE_GRASS_W,
    TILE_GRASS_E,
    TILE_GRASS_SW,
    TILE_GRASS_SE,
    TILE_SIGN,
    TILE_BLACK,
    TILE_PLATINE_NE,
    TILE_PLATINE_NW,
    TILE_SCREEN_SIGN,
    TILE_DOOR_OPENED,
    TILE_DOOR_YELLOW_CENTER,
    TILE_DOOR_GREEN_CENTER,
    TILE_DOOR_BLUE_CENTER,
    TILE_DOOR_RED_BOTTOM,
    TILE_DOOR_YELLOW_BOTTOM,
    TILE_DOOR_GREEN_BOTTOM,
    TILE_DOOR_BLUE_BOTTOM,
    TILE_METAL_DOOR,
    TILE_METAL_DOOR_OPEN,
    TILE_METAL_WALL_V,
    TILE_METAL_WALL_H,
    TILE_METAL_WALL_V_TILED,
    TILE_METAL_WALL_H_TILED,
    TILE_CYBER_BACK,
    TILE_WALL_HOLDER_N,
    TILE_WALL_HOLDER_E,
    TILE_WALL_HOLDER_W,
    TILE_WALL_HOLDER_S,
    TILE_METAL_PLATFORM,
    TILE_A,
    TILE_B,
    TILE_C,
    TILE_D,
    TILE_1,
    TILE_2,
    TILE_3,
    TILE_4,
    TILE_ARROW_RIGHT,
    TILE_ARROW_LEFT,
    TILE_LOCKDOWN,
    TILE_LOCKDOWN_OPEN,
    TILE_TRAIN_TRACK,
    TILE_SPIKES_N,
    TILE_SPIKES_E,
    TILE_SPIKES_W,
    TILE_SPIKES_S,
    TILE_WATER_TOP,
    TILE_WATER,
    TILE_PLATINE_CHIP_E,
    TILE_PLATINE_CHIP_W,
    TILE_PLATINE_CHIP_S,
    TILE_PLATINE_CHIP_N,
    TILE_PLATINE_GRID_H,
    TILE_PLATINE_GRID_V,
    TILE_PLATINE_GRID_NE,
    TILE_PLATINE_GRID_NW,
    TILE_PLATINE_GRID_SE,
    TILE_PLATINE_GRID_SW,
    TILE_KELP_1,
    TILE_KELP_2,
    TILE_KELP_V_1,
    TILE_KELP_V_2,
    TILE_METAL_WALL_EDGE_LO,
    TILE_METAL_WALL_EDGE_RO,
    TILE_METAL_WALL_EDGE_LU,
    TILE_METAL_WALL_EDGE_RU,

    TILE_LAST_ENTRY,
  };

  enum EntityTypes
  {
    ENTITY_TYPE_NONE      = 0,
    ENTITY_TYPE_TOKEN,
    ENTITY_TYPE_PLAYER,
    ENTITY_TYPE_EXIT,
    ENTITY_TYPE_KEY_RED,
    ENTITY_TYPE_KEY_GREEN,
    ENTITY_TYPE_KEY_BLUE,
    ENTITY_TYPE_KEY_YELLOW,
    ENTITY_TYPE_DOOR,
    ENTITY_TYPE_BUG_L,
    ENTITY_TYPE_BUG_R,
    ENTITY_TYPE_CAR,
    ENTITY_TYPE_SWITCH,
    ENTITY_TYPE_TOKEN_COLLECTOR,
    ENTITY_TYPE_LASER_D,
    ENTITY_TYPE_LASER_U,
    ENTITY_TYPE_LASER_L,
    ENTITY_TYPE_LASER_R,
    ENTITY_TYPE_LASER_H,
    ENTITY_TYPE_LASER_V,
    ENTITY_TYPE_PLAYER_EXPLOSION,
    ENTITY_TYPE_DOOR_LOCKED,
    ENTITY_TYPE_EYE,
    ENTITY_TYPE_THROWN_TOKEN,
    ENTITY_TYPE_EXPLOSION,
    ENTITY_TYPE_ANOMALY,
    ENTITY_TYPE_SHOT,
    ENTITY_TYPE_PLATFORM,
    ENTITY_TYPE_DELETER,
    ENTITY_TYPE_PARTICLE_EXPLOSION,
    ENTITY_TYPE_CANNON,
    ENTITY_TYPE_FISH_L,
    ENTITY_TYPE_FISH_R,
    ENTITY_TYPE_SUB,
    ENTITY_TYPE_SUB_SHOT,
    ENTITY_TYPE_SECURITY_PASS,
    ENTITY_TYPE_FLY,
    ENTITY_TYPE_SHODAN,

    ENTITY_LAST_ENTRY,

    // all entites after here are not editable
    //ENTITY_TYPE_FX,
  };

  enum SpriteTypes
  {
    ST_UNKNOWN = 0,
    ST_BACKGROUND,
    ST_OBJECT,
    ST_BUTTON,
  };

  enum BlockedTypes
  {
    BLOCKED_NONE    = 0,
    BLOCKED_LEFT    = 0x00000001,
    BLOCKED_RIGHT   = 0x00000002,
    BLOCKED_TOP     = 0x00000004,
    BLOCKED_BOTTOM  = 0x00000008,

    BLOCKED_X       = BLOCKED_LEFT | BLOCKED_RIGHT,
    BLOCKED_Y       = BLOCKED_TOP | BLOCKED_BOTTOM,
  };

  enum KeyType
  {
    KEY_BLUE        = 0,
    KEY_GREEN,
    KEY_RED,
    KEY_YELLOW,
  };

  enum PlayerState
  {
    STATE_OK,
    STATE_IN_VEHICLE,
    STATE_IN_CANNON,
    STATE_IN_SUB,
    STATE_WARPING,
  };

  enum AnimationIndex
  {
    ANIM_NONE,
    ANIM_PLAYER_RUN_LEFT,
    ANIM_PLAYER_RUN_RIGHT,
    ANIM_PLAYER_JUMP_LEFT,
    ANIM_PLAYER_JUMP_RIGHT,
    ANIM_PLAYER_STAND_LEFT,
    ANIM_PLAYER_STAND_RIGHT,
    ANIM_PLAYER_DROP_LEFT,
    ANIM_PLAYER_DROP_RIGHT,
    ANIM_TOKEN_ROTATE,
    ANIM_FX_STAR_1,
    ANIM_FX_STAR_2,
    ANIM_FX_STAR_3,
    ANIM_KEY_BLUE,
    ANIM_KEY_RED,
    ANIM_KEY_GREEN,
    ANIM_KEY_YELLOW,
    ANIM_SHOE,
    ANIM_EXIT_SIGN,
    ANIM_DOOR,
    ANIM_BUG_WALK_L,
    ANIM_BUG_WALK_R,
    ANIM_CAR,
    ANIM_SWITCH_ON,
    ANIM_SWITCH_OFF,
    ANIM_TOKEN_COLLECTOR,
    ANIM_LASER_D,
    ANIM_LASER_U,
    ANIM_LASER_L,
    ANIM_LASER_R,
    ANIM_LASER_H,
    ANIM_LASER_V,
    ANIM_EXPLOSION,
    ANIM_DOOR_LOCKED,
    ANIM_EYE_OPEN,
    ANIM_EYE_LOOK,
    ANIM_EYE_SLEEP,
    ANIM_EYE_CLOSE,
    ANIM_ENEMY_EXPLODE,
    ANIM_ANOMALY,
    ANIM_SHOT,
    ANIM_PLATFORM,
    ANIM_EXPLOSION_PARTICLE_BIG,
    ANIM_EXPLOSION_PARTICLE_MEDIUM,
    ANIM_EXPLOSION_PARTICLE_SMALL,
    ANIM_CANNON,
    ANIM_WATER_TOP,
    ANIM_FISH_SWIM_L,
    ANIM_FISH_SWIM_R,
    ANIM_FISH_JUMP,
    ANIM_FISH_FALL,
    ANIM_CANNON_FULL,
    ANIM_SUB_R,
    ANIM_SUB_L,
    ANIM_SUB_EMPTY,
    ANIM_BUBBLE_BIG,
    ANIM_BUBBLE_SMALL,
    ANIM_SUB_SHOT,
    ANIM_PLAYER_WARP,
    ANIM_SECURITY_PASS,
    ANIM_FLY_R,
    ANIM_FLY_L,
    ANIM_SHODAN,
  };

  struct Tile
  {
    TileType      Type;
    unsigned int  Color;
    unsigned int  Flags;

    Tile( TileType Type = TILE_EMPTY, unsigned int Color = 0xffffffff, unsigned int Flags = 0 ) :
      Type( Type ),
      Color( Color ),
      Flags( Flags )
    {
    }
  };

  enum GameEvent
  {
    GE_NONE,
    GE_STOP_ALARM,
    GE_START_ALARM,
    GE_ENABLE_LAYER_1,
    GE_ENABLE_LAYER_2,
    GE_ENABLE_LAYER_3,
    GE_DISABLE_LAYER_1,
    GE_DISABLE_LAYER_2,
    GE_DISABLE_LAYER_3,
    GE_TOGGLE_LAYER_1,
    GE_TOGGLE_LAYER_2,
    GE_TOGGLE_LAYER_3,
    GE_PLAYER_DIED,
    GE_STOP_ALARM_ANOMALY,
    GE_SHODAN_KILLED,
  };

  enum ParticleType
  {
    EXPLOSION_BIG,
    EXPLOSION_MEDIUM,
    EXPLOSION_SMALL,
    CANNON_SMOKE,
    BUBBLE_BIG,
    BUBBLE_SMALL,
    SPLASH,
  };

};